%% Script to transform the Joint Reaction forces to the Relevant Model
% 
% Requires several input files to be available in the relevant patient
% folder.
%
%
% 
disp('')
disp(['Ensure that the files: ''timepoints.mat'' and ''PX_62.mat'' are in the directory, and trans.mat'])
disp('')
%
BasePath = pwd;
% 
%
for PatientN=[28];
    %
    %% Get required files from chair_rise directory
    DirName = sprintf('/P%d/',PatientN);
    %
    cd (fullfile(BasePath,DirName))
    %
    patient_points=['load P',num2str(PatientN),'_62.mat'];
    eval(patient_points)
    load trans
    load timepoints
    %
    %% JointR directory
    DirName = sprintf('/P%d/',PatientN);
    %
    cd (fullfile(BasePath,DirName))
    %
    load Heights_Weights
    load Lat100
    load Med100
    %

    %% First transform reactions to local coordinate system
    %
    trans_med100=TransFunRotOnly(Med100,trans);
    trans_lat100=TransFunRotOnly(Lat100,trans);
    %
    %%
    %
    str2=['plot3(P',num2str(PatientN),'_62(:,1),P',num2str(PatientN),'_62(:,2),P',num2str(PatientN),'_62(:,3),''x'');'];
    eval(str2)
    %
    % Get centre of the knee
    % 62.5 % of (lateral - medial vector ) + medial point.
    str=['KneeCentre=0.625*(P',num2str(PatientN),'_62(4,:)-P',num2str(PatientN),'_62(3,:))+P',num2str(PatientN),'_62(3,:)'];
    %
    eval(str)
    % Get centre of the ankle
    % 50 % of (lateral - medial vector ) + medial point.
    str=['AnkleCentre=0.5*(P',num2str(PatientN),'_62(7,:)-P',num2str(PatientN),'_62(6,:))+P',num2str(PatientN),'_62(6,:)'];
    eval(str)
    %
    str=['HipCentre=P',num2str(PatientN),'_62(1,:)'];
    eval(str)
    %
    axis equal
    hold on
    plot3(KneeCentre(:,1),KneeCentre(:,2),KneeCentre(:,3),'ro')
    plot3(HipCentre(:,1),HipCentre(:,2),HipCentre(:,3),'ro')
    %
    %% Reaction Forces
    % Get Hip-Knee unit vector
    %
    %JointUnitV=(KneeCentre-HipCentre);
    %JointUnitV=JointUnitV/norm(JointUnitV)
    %
    % Get Medial and Lateral Joint Forces
    %
    counter=1;
    for GaitInstance = timepoints
        MedJointR(counter,:)=trans_med100(GaitInstance+1,:);
        LatJointR(counter,:)=trans_lat100(GaitInstance+1,:);
        counter = counter + 1;
        %
    end
    %
    %% Scale to patient weight
    MedJointR=MedJointR*heights_cm_weights_kg(PatientN,2) / 65.0;
    LatJointR=LatJointR*heights_cm_weights_kg(PatientN,2) / 65.0;
    %
    % Write to the csv
    csvwrite(['MedJointR_Cycle.csv'],MedJointR)
    csvwrite(['LatJointR_Cycle.csv'],LatJointR)
    csvwrite('timepoints.csv',timepoints)
    %
    %% Locations
    % Medial Joint Location
    str3=['MedJointLoc=0.25*(P',num2str(PatientN),'_62(4,:)-P',num2str(PatientN),'_62(3,:))+P',num2str(PatientN),'_62(3,:);'];
    eval(str3)
    % Laterial Joint Location
    str3=['LatJointLoc=0.75*(P',num2str(PatientN),'_62(4,:)-P',num2str(PatientN),'_62(3,:))+P',num2str(PatientN),'_62(3,:);'];
    eval(str3)
    % Write the csv
    csvwrite('MedJointLoc.csv',MedJointLoc)
    csvwrite('LatJointLoc.csv',LatJointLoc)
    %
end
disp(['Patient ',num2str(PatientN),' Complete!'])

clear HipCentre
clear KneeCentre
clear BasePath
clear AnkleCentre
clear counter
clear GaitInstance
clear patient_points
clear str
clear str2
clear str3
clear trans_lat100
clear trans_med100
clear heights_cm_weights_kg
clear DirName
clear Lat100
clear Med100

